package {
	
	import away3d.core.base.Vertex;
	import away3d.core.math.Matrix3D;
	import away3d.core.math.Number3D;
	
	public class Away3DMathUtil {
		
		public static function multiplyMatri3DVertex(m:Matrix3D, vi:Vertex, vo:Vertex):Vertex {
			var vx:Number = vi.x;
			var vy:Number = vi.y;
			var vz:Number = vi.z;
			vo.x = vx * m.sxx + vy * m.sxy + vz * m.sxz + m.tx;
			vo.y = vx * m.syx + vy * m.syy + vz * m.syz + m.ty;
			vo.z = vx * m.szx + vy * m.szy + vz * m.szz + m.tz;
			return vo;
		}

		public static function multiplyMatri3DNumber3D(m:Matrix3D, ni:Number3D, no:Number3D = null):Number3D {
			var vx:Number = ni.x;
			var vy:Number = ni.y;
			var vz:Number = ni.z;
			var no:Number3D = no || new Number3D();
			no.x = vx * m.sxx + vy * m.sxy + vz * m.sxz + m.tx;
			no.y = vx * m.syx + vy * m.syy + vz * m.syz + m.ty;
			no.z = vx * m.szx + vy * m.szy + vz * m.szz + m.tz;
			return no;
		}
	}
}